Attribute VB_Name = "Module1"
'{Copyright  2003 by Cioina Alexei <cioina@usm.md, cioina@hotmail.com>. All rights reserved.}

Public Declare Sub CreateList Lib "Cioina.DLL" ()
Public Declare Sub ClearList Lib "Cioina.DLL" ()
Public Declare Sub ClearSharedVariables Lib "Cioina.DLL" ()
Public Declare Sub ClearUserFunctions Lib "Cioina.DLL" ()
Public Declare Sub FreeAll Lib "Cioina.DLL" ()
Public Declare Sub AddMathExpression Lib "Cioina.DLL" ()
Public Declare Sub AddMathExpressionWithUserFunctions Lib "Cioina.DLL" ()
Public Declare Sub AddSharedVar Lib "Cioina.DLL" (ByVal VarName As String, ByVal DefValue As Double, ByVal Protect As Boolean)
Public Declare Sub AddUserFunctionInVB Lib "Cioina.DLL" (ByVal FuncName As String, ByVal FuncAddress As Long, ByVal ParamCount As Long)
Public Declare Sub ClearMathExpression Lib "Cioina.DLL" (ByVal id As Long)
Public Declare Sub DeleteParantheses Lib "Cioina.DLL" (ByVal id As Long, ByVal s As String, ByRef res As String)
Public Declare Sub ExpressionReplace Lib "Cioina.DLL" (ByVal id As Long, ByVal s As String, ByVal OldPattern As String, ByVal NewPattern As String, ByRef res As String)
Public Declare Sub Parse Lib "Cioina.DLL" (ByVal id As Long, ByVal MathStr As String, ByVal VarStr As String, ByVal CheckUnknownVar As Boolean)
Public Declare Sub ParseAndDifferentiate Lib "Cioina.DLL" (ByVal id As Long, ByVal MathStr As String, ByVal VarStr As String, ByVal DerStr As String, ByVal CheckUnknownVar As Boolean)
Public Declare Sub ParseAndDifferentiateWithSharedVar Lib "Cioina.DLL" (ByVal id As Long, ByVal MathStr As String, ByVal DerStr As String, ByVal CheckUnknownVar As Boolean)
Public Declare Sub ParseWithSharedVar Lib "Cioina.DLL" (ByVal id As Long, ByVal MathStr As String, ByVal CheckUnknownVar As Boolean)
Public Declare Function DoMathExpression Lib "Cioina.DLL" (ByVal id As Long) As Double
Public Declare Sub DoVectorOfMathExpressions Lib "Cioina.DLL" (ByVal id As Long)
Public Declare Function GetListCount Lib "Cioina.DLL" () As Long
Public Declare Function GetErrorFlag Lib "Cioina.DLL" (ByVal id As Long) As Boolean
Public Declare Function GetIsMathExpressionVariable Lib "Cioina.DLL" (ByVal id As Long) As Boolean
Public Declare Function GetIsMathExpressionPublic Lib "Cioina.DLL" (ByVal id As Long) As Boolean
Public Declare Function GetIsMathExpressionProtected Lib "Cioina.DLL" (ByVal id As Long) As Boolean
Public Declare Function GetIsMathExpressionLinear Lib "Cioina.DLL" (ByVal id As Long) As Boolean
Public Declare Sub GetErrorMessageInfo Lib "Cioina.DLL" (ByVal id As Long, ByRef res As String)
Public Declare Function GetErrorNumber Lib "Cioina.DLL" (ByVal id As Long) As Long
Public Declare Function GetSharedVar Lib "Cioina.DLL" (ByVal i As Long) As Double
Public Declare Function GetSharedVarCount Lib "Cioina.DLL" () As Long
Public Declare Function GetVariableCount Lib "Cioina.DLL" (ByVal id As Long) As Long
Public Declare Function GetVariableLowIndex Lib "Cioina.DLL" (ByVal id As Long) As Long
Public Declare Sub GetVariableName Lib "Cioina.DLL" (ByVal id As Long, ByVal i As Long, ByRef res As String)
Public Declare Function GetVariableValue Lib "Cioina.DLL" (ByVal id As Long, ByVal i As Long) As Double
Public Declare Function IsValidIdentName Lib "Cioina.DLL" (ByVal id As Long, ByVal s As String) As Boolean
Public Declare Sub ClearDerivativeExpressionString Lib "Cioina.DLL" (ByVal id As Long)
Public Declare Sub ClearMathExpressionString Lib "Cioina.DLL" (ByVal id As Long)
Public Declare Sub SetSharedVar Lib "Cioina.DLL" (ByVal i As Long, ByVal Value As Double)
Public Declare Sub SetVariableValue Lib "Cioina.DLL" (ByVal id As Long, ByVal i As Long, ByVal Value As Double)
Public Declare Sub GetMathematicaFormVariableNames Lib "Cioina.DLL" (ByVal id As Long, ByRef res As String)
Public Declare Function GetMathExpressionCount Lib "Cioina.DLL" (ByVal id As Long) As Long
Public Declare Sub GetMathExpressionString Lib "Cioina.DLL" (ByVal id As Long, ByRef res As String)
Public Declare Function GetMaxIterations Lib "Cioina.DLL" (ByVal id As Long) As Long
Public Declare Function GetProtectVariablesEndedWithNumber Lib "Cioina.DLL" (ByVal id As Long) As Boolean
Public Declare Function GetProtectVariablesEndedWithoutNumber Lib "Cioina.DLL" (ByVal id As Long) As Boolean
Public Declare Function GetValuesVectorCount Lib "Cioina.DLL" () As Long
Public Declare Function GetValuesVector Lib "Cioina.DLL" (ByVal i As Long) As Double
Public Declare Sub SetProtectVariablesEndedWithNumber Lib "Cioina.DLL" (ByVal id As Long, ByVal Value As Boolean)
Public Declare Sub SetProtectVariablesEndedWithoutNumber Lib "Cioina.DLL" (ByVal id As Long, ByVal Value As Boolean)
Public Declare Function GetMaxStack Lib "Cioina.DLL" (ByVal id As Long) As Long
Public Declare Function GetSpaceLikeMultiply Lib "Cioina.DLL" (ByVal id As Long) As Boolean
Public Declare Function GetTotalFunctionCount Lib "Cioina.DLL" (ByVal id As Long) As Long
Public Declare Sub SetMaxIterations Lib "Cioina.DLL" (ByVal id As Long, ByVal Value As Long)
Public Declare Sub SetMaxStack Lib "Cioina.DLL" (ByVal id As Long, ByVal Value As Long)
Public Declare Sub SetSpaceLikeMultiply Lib "Cioina.DLL" (ByVal id As Long, ByVal Value As Boolean)
Public Declare Sub GetDerivativeExpressionString Lib "Cioina.DLL" (ByVal id As Long, ByRef res As String)
Public Declare Sub GetDerivativeVariableString Lib "Cioina.DLL" (ByVal id As Long, ByRef res As String)
Public Declare Sub GetMathematicaFormDerivativeExpressionString Lib "Cioina.DLL" (ByVal id As Long, ByRef res As String)
Public Declare Sub GetMathematicaFormMathExpressionString Lib "Cioina.DLL" (ByVal id As Long, ByRef res As String)
Public Declare Function GetMathException Lib "Cioina.DLL" (ByVal id As Long) As Long
Public Declare Function GetPowerOperator Lib "Cioina.DLL" (ByVal id As Long) As Boolean
Public Declare Sub SetPowerOperator Lib "Cioina.DLL" (ByVal id As Long, ByVal Value As Boolean)
Public Declare Function GetAllocDynamicMemoryInfo Lib "Cioina.DLL" (ByVal id As Long) As Long
Public Declare Function GetRunTimeFunctionCount Lib "Cioina.DLL" (ByVal id As Long) As Long
Public Declare Sub GetBuiltInFunctionInfo Lib "Cioina.DLL" (ByVal id As Long, ByVal i As Long, ByRef res As String)
Public Declare Function GetBuiltInFunctionCount Lib "Cioina.DLL" () As Long
Public Declare Sub GetBuiltInFunctionName Lib "Cioina.DLL" (ByVal i As Long, ByRef res As String)
Public Declare Sub GetRunTimeFunctionName Lib "Cioina.DLL" (ByVal id As Long, ByVal i As Long, ByRef res As String)
Public Declare Sub GetRunTimeFunctionDefinition Lib "Cioina.DLL" (ByVal id As Long, ByVal i As Long, ByRef res As String)
Public Declare Sub GetExceptionInfo Lib "Cioina.DLL" (ByVal id As Long, ByVal i As Long, ByRef res As String)
Public Declare Function GetOriginalMathExpressionString Lib "Cioina.DLL" (ByVal id As Long) As Boolean
Public Declare Sub GetOwnerInfo Lib "Cioina.DLL" (ByRef res As String)
Public Declare Sub GetTypeInfo Lib "Cioina.DLL" (ByRef res As String)
Public Declare Sub GetVersionInfo Lib "Cioina.DLL" (ByRef res As String)
Public Declare Sub GetDedicationInfo Lib "Cioina.DLL" (ByRef res As String)
Public Declare Sub SetOriginalMathExpressionString Lib "Cioina.DLL" (ByVal id As Long, ByVal Value As Boolean)
Public Declare Sub GetLastErrorMessage Lib "Cioina.DLL" (ByRef res As String)
Public Declare Sub SetLastErrorMessage Lib "Cioina.DLL" (ByVal s As String)
Public Declare Function GetLastErrorFlag Lib "Cioina.DLL" () As Boolean
Public Declare Sub SetLastErrorFlag Lib "Cioina.DLL" (ByVal flg As Boolean)
Public Declare Function GetLastErrorNumber Lib "Cioina.DLL" () As Long
Public Declare Sub SetLastErrorNumber Lib "Cioina.DLL" (ByVal i As Long)
Public Declare Function Prm Lib "Cioina.DLL" (ByVal i As Long) As Double
Public Declare Function GetFPU8087CW Lib "Cioina.DLL" () As Integer
Public Declare Sub SetFPU8087CW Lib "Cioina.DLL" (ByVal i As Integer)

Public Const MAX_PARAM_COUNT As Long = 2147483647

Public Const EX_NONMATH As Long = 0
Public Const EX_Overflow As Long = 1
Public Const EX_Underflow As Long = 2
Public Const EX_InvalidArgument As Long = 3
Public Const EX_ZeroDivide As Long = 4
Public Const EX_InvalidOp As Long = 5

Public Const ERR_NOERROR As Long = 0
Public Const ERR_NO_MATH_EXPRESSION_WAS_PARSED As Long = -1
Public Const ERR_PARANTHESES_SYNTAX_ERROR As Long = -2
Public Const ERR_INVALID_DERIVATIVE_VARIABLE_NAME As Long = -3
Public Const ERR_MATH_EXPRESSION_IS_EMPTY As Long = -4
Public Const ERR_IDENTIFIER_CANNOT_BE_EMPTY As Long = -5
Public Const ERR_IDENTIFIER_LENGTH As Long = -6
Public Const ERR_NOT_PASCAL_IDENTIFIER As Long = -7
Public Const ERR_IDENTIFIER_CANNOT_BE_RESERVED_NAME As Long = -8
Public Const ERR_IDENTIFIER_ALREADY_EXISTS As Long = -9
Public Const ERR_DUBLICATING_USER_IDENTIFIER As Long = -10
Public Const ERR_UNKNOWN_EXPRESSION As Long = -11
Public Const ERR_BAD_EXPONENTIAL_FORMAT As Long = -12
Public Const ERR_SET_OriginalMathExpressionString_FALSE As Long = -13
Public Const ERR_MATH_EXPRESSION_WAS_ERASED As Long = -14
Public Const ERR_USE_VerifySyntaxSemanticsAndDerivation As Long = -15
Public Const ERR_DERIVATIVE_EXPRESSION_WAS_ERASED As Long = -16
Public Const ERR_VARIABLES_AND_VALUES_ARE_DIFFERENT As Long = -17
Public Const ERR_MATH_EXPRESSIONS_ARRAY As Long = -18
Public Const ERR_FUNCTION_NUMBER_MUST_BE_LESS As Long = -19
Public Const ERR_FUNCTION_ADDRESS_CANNOT_BE_NIL As Long = -20
Public Const ERR_PROTECTED_EXPRESSION As Long = -21
Public Const ERR_PARSE As Long = -22
Public Const ERR_EXECUTE As Long = -23
Public Const ERR_DYNAMIC_MEMORY As Long = -24
Public Const ERR_MULTIPLY As Long = -25
Public Const ERR_DIVISION As Long = -26
Public Const ERR_PLUS As Long = -27
Public Const ERR_MINUS As Long = -28
Public Const ERR_POWER As Long = -29
Public Const ERR_EQUAL As Long = -30
Public Const ERR_UNKNOWN_FUNCTION As Long = -31
Public Const ERR_UNKNOWN_VARIABLE As Long = -32
Public Const ERR_BAD_SYNTAX As Long = -33
Public Const ERR_COMMA_SYNTAX As Long = -34
Public Const ERR_SYSTEM_STACK_OVERFLOW As Long = -35
Public Const ERR_DEF_FUNC_NAME As Long = -36
Public Const ERR_DEF_FUNC_DUBLICATING As Long = -37
Public Const ERR_DEF_FUNC_IMPLEMENTING As Long = -38
Public Const ERR_DEF_FUNC_ARG_COUNT As Long = -39
Public Const ERR_DEF_FUNC_ARG_NAME As Long = -40
Public Const ERR_DEF_FUNC_ARG_DUBLICATING As Long = -41
Public Const ERR_DEF_FUNCTION_STACK_OVERFLOW As Long = -42


Public Function ErrorMessage() As String
 Dim s1, tmp As String, i As Long

  If Not GetLastErrorFlag Then
   ErrorMessage = "No Error"
   Exit Function
  End If
  GetLastErrorMessage tmp
  i = InStr(tmp, ":")
  If i > 0 Then
   s1 = " : " + Mid(tmp, i + 1, Len(tmp) - i)
  End If
  If Len(s1) > 256 Then
   s1 = Mid(s1, 1, 256)
  End If
  
  s1 = LCase(s1)
  
Select Case GetLastErrorNumber
 Case ERR_PARSE
       ErrorMessage = "Invalid expression" + s1
 Case ERR_BAD_SYNTAX
       ErrorMessage = "Syntax error" + s1
 Case ERR_COMMA_SYNTAX
       ErrorMessage = "Comma syntax error" + s1
 Case ERR_NO_MATH_EXPRESSION_WAS_PARSED
       ErrorMessage = "No math expression was parsed"
 Case ERR_PARANTHESES_SYNTAX_ERROR
       ErrorMessage = "Mismatched parenthesis"
 Case ERR_INVALID_DERIVATIVE_VARIABLE_NAME
       ErrorMessage = "Invalid name of derivative variable" + s1
 Case ERR_MATH_EXPRESSION_IS_EMPTY
       ErrorMessage = "Mathematical expression is empty"
 Case ERR_IDENTIFIER_CANNOT_BE_EMPTY
       ErrorMessage = "Identifier cannot be empty"
 Case ERR_IDENTIFIER_LENGTH
       ErrorMessage = "Identifier length is too long" + s1
 Case ERR_NOT_PASCAL_IDENTIFIER
       ErrorMessage = "Invalid identifier" + s1
 Case ERR_IDENTIFIER_CANNOT_BE_RESERVED_NAME
       ErrorMessage = "Identifier cannot be a reserved name" + s1
 Case ERR_IDENTIFIER_ALREADY_EXISTS
       ErrorMessage = "Identifier already exists" + s1
 Case ERR_DUBLICATING_USER_IDENTIFIER
       ErrorMessage = "Dublicating user identifier" + s1
 Case ERR_UNKNOWN_EXPRESSION
       ErrorMessage = "Unknown expression" + s1
 Case ERR_UNKNOWN_FUNCTION
       ErrorMessage = "Undefined function" + s1
 Case ERR_UNKNOWN_VARIABLE
       ErrorMessage = "Undefined variable" + s1
 Case ERR_BAD_EXPONENTIAL_FORMAT
       ErrorMessage = "Invalid exponent value" + s1
 Case ERR_SET_OriginalMathExpressionString_FALSE
       ErrorMessage = "Set *OriginalMathExpressionString* to FALSE for differentiation or for Mathematica 4.1 export"
 Case ERR_MATH_EXPRESSION_WAS_ERASED
       ErrorMessage = "Mathematical expression string was erased"
 Case ERR_USE_VerifySyntaxSemanticsAndDerivation
       ErrorMessage = "Use *VerifySyntaxSemanticsAndDerivation* for differentiation"
 Case ERR_DERIVATIVE_EXPRESSION_WAS_ERASED
       ErrorMessage = "Derivative expression string was erased"
 Case ERR_VARIABLES_AND_VALUES_ARE_DIFFERENT
       ErrorMessage = "Variable count and value caunt do not corespond"
 Case ERR_MATH_EXPRESSIONS_ARRAY
       ErrorMessage = "Use *DoVectorOfMathExpressions* for calculate a vector of math expression"
 Case ERR_FUNCTION_NUMBER_MUST_BE_LESS
       ErrorMessage = "Function number must be less" + s1
 Case ERR_FUNCTION_ADDRESS_CANNOT_BE_NIL
       ErrorMessage = "Function address cannot be nil" + s1
 Case ERR_PROTECTED_EXPRESSION
       ErrorMessage = "Cannot set value for protected expression" + s1
 Case ERR_DEF_FUNC_NAME
       ErrorMessage = "Invalid function name" + s1
 Case ERR_DEF_FUNC_DUBLICATING
       ErrorMessage = "Dublicating defined function" + s1
 Case ERR_DEF_FUNC_IMPLEMENTING
       ErrorMessage = "Defined function was not implimented" + s1
 Case ERR_DEF_FUNC_ARG_COUNT
       ErrorMessage = "Invalid arguments number for defined function" + s1
 Case ERR_DEF_FUNC_ARG_NAME
       ErrorMessage = "Invalid argument name for defined function" + s1
 Case ERR_DEF_FUNC_ARG_DUBLICATING
       ErrorMessage = "Dublicating argument name for defined function" + s1
  Case ERR_NO_MATH_EXPRESSION_WAS_PARSED
       ExecuteErrorMessage = "No math expression was parsed"
 Case ERR_VARIABLES_AND_VALUES_ARE_DIFFERENT
       ExecuteErrorMessage = "Variable count and value caunt do not corespond"
 Case ERR_MATH_EXPRESSIONS_ARRAY
       ExecuteErrorMessage = "Use *DoVectorOfMathExpressions* for calculate a vector of math expression"
 Case ERR_EXECUTE
       ExecuteErrorMessage = "Execution error"
 Case ERR_DEF_FUNCTION_STACK_OVERFLOW
       ExecuteErrorMessage = "Stack overflow" + s1
 Case ERR_SYSTEM_STACK_OVERFLOW
       ExecuteErrorMessage = "Fatal error" + s1
 Case ERR_MULTIPLY
       ErrorMessage = "Invalid value for *" + s1
 Case ERR_DIVISION
       ErrorMessage = "Invalid value for /" + s1
 Case ERR_PLUS
       ErrorMessage = "Invalid value for +" + s1
 Case ERR_MINUS
       ErrorMessage = "Invalid value for -" + s1
 Case ERR_POWER
       ErrorMessage = "Invalid value for ^" + s1
 Case ERR_EQUAL
       ErrorMessage = "Invalid value for =" + s1
  Case Else
   If (GetLastErrorNumber >= 1) And (GetLastErrorNumber <= GetBuiltInFunctionCount) Then
    GetBuiltInFunctionName GetLastErrorNumber, tmp
    If s = "" Then
      ErrorMessage = "Invalid number of function arguments for: " + UCase(tmp)
    Else
      ErrorMessage = "Invalid value for " + UCase(tmp) + s1
    End If
   Else
    GetLastErrorMessage tmp
    ErrorMessage = tmp
   End If
End Select
End Function




